
;	*************************************************************************
;	*************************************************************************
;	* Mars 2023 / FABRICE NORO  Software . All right RESERVED  				*
;	*   Pilotage motor SUR CARTE POUR AUTOMATION mobile					    *
;	*************************************************************************
;	*************************************************************************

	list P = PIC16F877a
	include "p16f877a.inc"
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_Off & _PWRTE_ON & _HS_OSC & _WRT_OFF & _LVP_OFF & _DEBUG_OFF & _CPD_OFF 


;	*********************************************************************
; 	*                      Compilo cheak level                          *
;	*********************************************************************

	ERRORLEVEL -302				

;	*********************************************************************
; 	*                            DEFINE                                 *
;	*********************************************************************

	#define	DrivePort	PortD	; motor drive 
	
	#define	SWOut 	portB,3	  ; "X"
	#define	SWIn	PortB,1   ; "R"
	#define	SW0		PortB,0   ; "Y" ( interupt possible )

;	*********************************************************************
; 	*                            Equal Assignation                      *
;	*********************************************************************

;Mot1on	equ	b'10100100'		

Pwm1 equ CCPR1L
Pwm2 equ CCPR2L

;	*********************************************************************
; 	*                               MACROS                              *
;	*********************************************************************



;	*********************************************************************
; 	*                    Declaration des Variables                      *
;	*********************************************************************

	CBLOCK 0x20
		;variable interupt
		TEMP
		W_TEMP
		STATUS_TEMP
		;variable tempo
		TB1
		TB2
		TBIP
		;Variable main

		CompteurA ; variable generique pour comptage dans boucle

		CI ; 	compteur interupt

		Adresse_AD		;lecture de quel AD est en cours

		Drivetemp
		LEDTemp
		SECUINIT


		Amp1 			; courant sortie 1
		Amp2 			; courant sortie 2
		Amp3 			; courant sortie 3
		Amp4 			; courant sortie 4
		Amp5 			; courant sortie 5
		Amp6 			; courant sortie 6
		Amp7 			; courant sortie 7
		Amp8 			; courant sortie 8

		Pot7 			; Position potar 7
		Pot8 			; Position potar 8

	ENDC

;	*********************************************************************
; 	*                            BIGUIN OF PROGRAM                      *
;	*********************************************************************
	org	0x000                              

	clrf	portb
	clrf	portc
	goto	Initialize		;	goto   program beguin


;	*********************************************************************
; 	*                        INTERUPTION (S)                    	    *
;	*********************************************************************
	org 0x004 
													
			movwf 	w_temp ; sauver registre W
			swapf 	STATUS,w
			clrf	STATUS	
			movwf 	status_temp

;GESTION AD

			BTFSC	CI,0
			BSF		ADCON0,GO   	;demare la conversion
			BTFSC	CI,0
			Goto Test_LED

			movfw	ADCON0
			ANDLW	B'00111000'   ;  fonction AND ,  garde que les 3 bits de canal d'AD
			MOVWF	Adresse_AD

;Case_1
			MOVFW	Adresse_AD
			SUBLW	B'00000000'
			BTFSS	Status,Z
			GOTO 	Case_2
			Movfw	ADRESH
			MovWF	Amp1
			
Case_2		
			MOVFW	Adresse_AD
			SUBLW	B'00001000'
			BTFSS	Status,Z
			GOTO 	Case_3
			Movfw	ADRESH
			MovWF	Amp2				

Case_3		
			MOVFW	Adresse_AD
			SUBLW	B'00010000'
			BTFSS	Status,Z
			GOTO 	Case_4
			Movfw	ADRESH
			MovWF	Amp3	

Case_4		
			MOVFW	Adresse_AD
			SUBLW	B'00011000'
			BTFSS	Status,Z
			GOTO 	Case_5
			Movfw	ADRESH
			MovWF	Amp4

Case_5		
			MOVFW	Adresse_AD
			SUBLW	B'00100000'
			BTFSS	Status,Z
			GOTO 	Case_6
			Movfw	ADRESH
			MovWF	Amp5

Case_6		
			MOVFW	Adresse_AD
			SUBLW	B'00101000'
			BTFSS	Status,Z
			GOTO 	Case_7
			Movfw	ADRESH
			MovWF	Amp6

Case_7		
			MOVFW	Adresse_AD
			SUBLW	B'00110000'
			BTFSS	Status,Z
			GOTO 	Case_8
			Movfw	ADRESH
			MovWF	Amp7
			MovWF	Pot7


Case_8		
			MOVFW	Adresse_AD
			SUBLW	B'00111000'
			BTFSS	Status,Z
			GOTO 	Case_end
			Movfw	ADRESH
			MovWF	Amp8
			MovWF	Pot8

			
Case_end


			Movlw	B'00001000'
			Addwf	ADCON0,f	  		;incremente le canal de l'ad
			BCF		ADCON0,6  		;clear la retenu




TEST_LED 
			BTFSS	CI,5
			call 	LED_V_on
			BTFSC	CI,5
			call	LED_V_off

			BTFSS	SW0
			call 	LED_V_on



			incf	CI

BCF	Intcon,2  ; clear interuption sur timer.


			swapf status_temp,w ; swap ancien status, rsultat dans w
			movwf STATUS ; restaurer status
			swapf w_temp,f ; Inversion L et H de l'ancien W
			; sans modifier Z
			swapf w_temp,w ; R-inversion de L et H dans W
			; W restaur sans modifier status

	retfie

;______________________________________________________________________________________________


Initialize		   ;		all the data for initialisation



;; 	================================ CONFIG =================================

banksel TRISA 


	movlw	B'00000000'	;  motor control port all output.
	movwf	TRISD  
	movlw	B'11001011'	; swich input 0,1,3 _  LED out 2,4,5 _ free 6,7  on port B
	movwf	TRISB  
	movlw	B'11111111'	; all input ( analog )
	movwf	TRISA		
	movlw	B'11101111'	; all input ( analog )
	movwf	TRISE
	movlw	B'11111001'	;     PWM out on RC1 et RC2          	
	movwf	TRISC	

; setup Timer0
	movlw	B'10010111'	 
 
	movwf	OPTION_REG

; Setup ADC
	movlw	B'01000000'
	movwf	ADCON1

;   set up PWM on timer 2
	movlw	d'255' ;et pr2=FF soit Fpwm=19 khz avec Qz de 20 mhz 				PWM set up
	movwf	pr2		;Fpwm (KHZ)= Fqz x 250:[(PR2+1)) x (TMR2 pr)] 






banksel	PORTA

; setup Timer 1
	movlw	B'00001101'	;  prescale 1 , internal clock.
	movwf	t1con


;	movlw	B'00000000'
	movlw	B'10100000'	;  set Interruption overflow timer 0 ( for filter )
;	movlw	B'10110000'	;  Interruption sur RB0 et par dbordement timer O
	movwf	intcon



	clrf	Driveport
	clrf	LEDTemp


; Setup ADC
	movlw	B'10000101'
	movwf	ADCON0

	movlw	0		;ne la largeur du PWM (de 0  255)
	movwf	CCPR2L		; pwm=ccpr2l x Tosc x tmr2 pr
	

	movlw	B'00000100'	; tmr2 on, Fpwm
	movwf	T2CON
	
	movlw	B'00111100'	; mode PWM SUR CCP2  ;PWM  output on  RC2   
	movwf	CCP2CON
	
	movlw	0
	movwf	CCPR1L		; pwm=ccpr2l x Tosc x tmr2 pr

	movlw	B'00000101'	; tmr2 on, Fpwm
	movwf	T1CON

	movlw	B'00111100'	; mode PWM SUR CCP2  ;PWM  output on  RC1   
	movwf	CCP1CON
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	clrf	Driveport
	clrf	LEDTemp



	CLRF	SECUINIT

			movlw	32
			Movwf	Pwm2
			Call	Mot_8_on
			call	MOT_7_ON
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65
Call	Delai65

Call	TESTSECUPOT
;**************************

			movlw	0
			Movwf	Pwm2
			Call	Mot_8_OFF
			call	MOT_7_OFF

	GOTO 	START



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;																				;
;							START MOTOR RUN		initiate						;
;																				;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Start


BLOC_ZERO
			Call	ALLOFF	
			Call	LED_R_OFF
					
			BTFSS	CI,5
			call 	LED_B_on
			BTFSC	CI,5
			call	LED_B_off

			movlw	0
			Movwf	Pwm1
			movlw	0
			Movwf	Pwm2

Call	TESTSECUPOT

			BTFSC	SWout
			GOTO	BLOC_ZERO
			GOTO	BLOC_ONE


;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::

BLOC_ONE    ; Bras principal  in/out
			call	LED_B_off
			Incf	CompteurA
			BTFSC	CompteurA,1
			call	LED_R_on
			BTFSS	CompteurA,1
			call	LED_R_off
			BTFSS	CompteurA,3
			call	LED_R_off

call	ALLOFF

			movlw	250
			Movwf	Pwm1
			movlw	32
			Movwf	Pwm2

			BTFSc	SWout
			GOTO    finforward12
			call	MOT_12_Forward
			Call	Mot_8_on
			call	MOT_7_ON
			BCf		Status,C
			movfw	POT8
			Addlw	180
			BTFSS	Status,C
			Goto 	BLOC_TWO
finforward12

			BTFSC	SECUINIT,0
			BTFSC	SWin
			GOTO	finreversed12
			call	ALLOFF
			call	MOT_12_Reverse
			call	MOT_7_ON
			call	MOT_8_ON
			movlw	250
			Movwf	Pwm1
			BCf		Status,C
			movfw	POT7
			sublw	180
			BTFSS	Status,C
			Goto 	BLOC_ZERO

finreversed12

Call	TESTSECUPOT

			call	delai65	
			Goto BLOC_ONE
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

BLOC_TWO   ; vollet1 in/out 

			call	LED_B_off
			Incf	CompteurA
			call	LED_R_off
			BTFSC	CompteurA,1
			call	LED_R_on

call	ALLOFF

			movlw	180
			Movwf	Pwm1
			movlw	0
			Movwf	Pwm2

			BTFSc	SWout
			GOTO    finforward34
			call	MOT_34_Forward
			Call	Mot_8_OFF
			call	MOT_7_OFF
			BCf		Status,C
			movfw	AMP4
			sublw	136
			BTFSS	Status,C
			Goto 	BLOC_TREE
finforward34

			BTFSC	SECUINIT,0
			BTFSC	SWin
			GOTO	finreversed34
			call	ALLOFF
			call	MOT_34_Reverse
			call	MOT_7_OFF
			call	MOT_8_OFF
			movlw	250
			Movwf	Pwm1
			BCf		Status,C
			movfw	AMP3
			sublw	134
			BTFSS	Status,C
			Goto 	BLOC_ONE

finreversed34

Call	TESTSECUPOT
			call	delai65	
			Goto 	BLOC_TWO

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BLOC_Tree   ; vollet2 in/out 

			call	LED_B_off
			Incf	CompteurA
			BTFSC	CompteurA,0
			call	LED_R_on
			BTFSS	CompteurA,0
			call	LED_R_off
			BTFSS	CompteurA,3
			call	LED_R_off
call	ALLOFF

			movlw	0
			Movwf	Pwm1
			movlw	180
			Movwf	Pwm2

			BTFSC	SECUINIT,0
			BTFSc	SWin
			GOTO    finforward56
			call	MOT_56_Forward
			Call	Mot_8_OFF
			call	MOT_7_OFF
			BCf		Status,C
			movfw	AMP6
			sublw	134
			BTFSS	Status,C
			Goto 	BLOC_TWO
finforward56

			BTFSC	SWout
			GOTO	finreversed56
			call	ALLOFF
			call	MOT_56_Reverse
			call	MOT_7_OFF
			call	MOT_8_OFF
			movlw	250
			Movwf	Pwm1
			BCf		Status,C
			movfw	AMP5
			sublw	136
			BTFSS	Status,C
			Goto 	BLOC_FOUR

finreversed56

Call	TESTSECUPOT
			call	delai65	
			Goto 	BLOC_Tree

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


BLOC_FOUR    ; Bras principal  in/out
			call	LED_B_off
			Incf	CompteurA
			call	LED_R_off
;			BTFSC	CompteurA,3
			call	LED_R_on

BSF	SECUINIT,0 ;accepte le repliage

call	ALLOFF

			movlw	250
			Movwf	Pwm1
			movlw	32
			Movwf	Pwm2

			BTFSc	SWin
			GOTO    finforward7
			call	MOT_12_Forward
			Call	Mot_8_on
			call	MOT_7_ON
			BCf		Status,C
			movfw	POT8
			Addlw	180
			BTFSS	Status,C
			Goto 	BLOC_TREE
finforward7

			
			BTFSC	SWout
			GOTO	finreversed7
			call	ALLOFF
			call	MOT_12_Reverse
			call	MOT_7_ON
			call	MOT_8_ON
			movlw	250
			Movwf	Pwm1
			BCf		Status,C
			movfw	POT8
			sublw	150
			BTFSS	Status,C
			Goto 	BLOC_FIVE

finreversed7

Call	TESTSECUPOT
			call	delai65	
			Goto 	BLOC_FOUR


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BLOC_FIVE   ; vollet in/out 

			call	LED_B_ON
			Incf	CompteurA
			call	LED_R_off

call	ALLOFF
			call	delai65	

			
Call	TESTSECUPOT

			BTFSC	SWIN
			GOTO	BLOC_FIVE
			GOTO	BLOC_Four



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;   Fin de run process, retour au debut ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;	*********************************************************************
; 	*                            Routine    mini prog                   *
;	*********************************************************************

;===>> commande LED

		LED_R_on 
		bsf		LEDTemp,5
		movfw	LEDTemp
		movwf	portB
		return
		
		LED_R_off 
		bcf		LEDTemp,5
		movfw	LEDTemp
		movwf	portB
		return
		
		LED_V_on 
		bsf		LEDTemp,4
		movfw	LEDTemp
		movwf	portB
		return
		
		LED_V_off 
		bcf		LEDTemp,4
		movfw	LEDTemp
		movwf	portB
		return
		
		LED_B_on 
		bsf		LEDTemp,2
		movfw	LEDTemp
		movwf	portB
		return
		
		LED_B_off 
		bcf		LEDTemp,2
		movfw	LEDTemp
		movwf	portB
		return

;===>> commande Moteur

		AllOFF
		call 	MOT_12_Stop
		call	MOT_34_Stop
		call	MOT_56_Stop
		call	MOT_7_OFF 
		call	MOT_8_OFF 
		return


		MOT_12_Forward 
		bcf		Drivetemp,0
		bsf		Drivetemp,1
		Movfw	Drivetemp
		movwf	DrivePort
		return

		MOT_12_Reverse 
		bcf		Drivetemp,1
		bsf		Drivetemp,0
		Movfw	Drivetemp
		movwf	DrivePort
		return


		MOT_12_Stop 
		bcf		Drivetemp,0
		bcf		Drivetemp,1
		Movfw	Drivetemp
		movwf	DrivePort
		return


		MOT_34_Forward 
		bcf		Drivetemp,2
		bsf		Drivetemp,3
		Movfw	Drivetemp
		movwf	DrivePort
		return

		MOT_34_Reverse 
		bcf		Drivetemp,3
		bsf		Drivetemp,2
		Movfw	Drivetemp
		movwf	DrivePort
		return


		MOT_34_Stop 
		bcf		Drivetemp,3
		bcf		Drivetemp,2
		Movfw	Drivetemp
		movwf	DrivePort
		return


		MOT_56_Forward 
		bcf		Drivetemp,4
		bsf		Drivetemp,5
		Movfw	Drivetemp
		movwf	DrivePort
		return

		MOT_56_Reverse 
		bcf		Drivetemp,5
		bsf		Drivetemp,4
		Movfw	Drivetemp
		movwf	DrivePort
		return


		MOT_56_Stop 
		bcf		Drivetemp,4
		bcf		Drivetemp,5
		Movfw	Drivetemp
		movwf	DrivePort
		return


		MOT_7_ON 
		bsf		Drivetemp,6
		Movfw	Drivetemp
		movwf	DrivePort
		return

		MOT_7_OFF 
		bcf		Drivetemp,6
		Movfw	Drivetemp
		movwf	DrivePort
		return

		MOT_8_ON 
		bsf		Drivetemp,7
		Movfw	Drivetemp
		movwf	DrivePort
		return

		MOT_8_OFF 
		bcf		Drivetemp,7
		Movfw	Drivetemp
		movwf	DrivePort
		return

;*****************************************************************************
TESTSECUPOT  ;SECURITE POTARS
			BCF		Status,C
			movfw	POT8
			sublw	205
			BTFSS	Status,C
			Goto 	SECU

			BCF		Status,C
			movfw	POT8
			sublw	40
			BTFSC	Status,C
			Goto 	SECU

			BCF		Status,C
			movfw	POT7
			sublw	205
			BTFSS	Status,C
			Goto 	SECU

			BCF		Status,C
			movfw	POT7
			sublw	40
			BTFSC	Status,C
			Goto 	SECU

			return
;*******************************************************************
SECU
			call 	ALLOFF
			Call	LED_V_ON
			Call	LED_B_ON
			Incf	CompteurA
			BTFSC	CompteurA,0
			call	LED_R_on
			BTFSS	CompteurA,0
			call	LED_R_off
BTFSC	CompteurA,0
			Call	FA
BTFSS	CompteurA,0
call	delai65
			GOTO 	SECU
;**********************************************************************
								
					
						retlw	0
					;=================================================================================================
					dly_1			;dlai de t2 x 8 s  so 
					;=================================================================================================
								
						movwf	tb2
					dpA	movlw	70
						movwf	tb1
						nop
					dpB	goto	$+1
						decfsz	tb1,f
						goto	dpB
						decfsz	tb2,f
						goto	dpA
						
								
					
						retlw	0


					;=================================================================================================
					dly8			;dlai de t2 x 8 s
					;=================================================================================================
						movwf	tb2
					dp0	movlw	7
						movwf	tb1
						nop
					dp1	goto	$+1
						decfsz	tb1,f
						goto	dp1
						decfsz	tb2,f
						goto	dp0
						retlw	0
					
					
					;=================================================================================================
					delai65			;65 ms
					;=================================================================================================
						clrf	tb1
						clrf	tb2
					d04
						goto	$+1
						decfsz	tb1,f
						goto	d04
						decfsz	tb2,f
						goto	d04
						retlw	0
					
					;=================================================================================================
					


						;--------------------------------- bip  FA ---------------------------------
					FA
	Movlw	250
	Movwf	PWM1

						movlw	100
						movwf	tbip
					hautF
						BTFSS	tbip,0
						goto	hautF2

						Call	MOT_12_Forward 
						movlw	80
						 call	dly8		;temps de ON
						goto	basF

					hautF2
						CALL 	MOT_12_Reverse 
						movlw	80
						 call	dly8		;temps de ON

					basF
						movlw	b'00000000'	;Ax, Bx, CH soit OFF
						movwf	driveport
						movlw	50
						 call	 dly8		;temps de OFF variable
						decfsz	tbip,f
						goto	hautF
						clrf	PWM1
						Call	AllOFF
						
					
						return


					
					;--------------------------------- bip  Do ---------------------------------
					DO
	Movlw	250
	Movwf	ccpr2L
	
						movlw	52
						movwf	tbip
					hautd
						movlw	b'01001000'	;Al, Bx, CH soit ON
						movwf	driveport
						movlw	6
						 call	dly8		;temps de ON
					bas

;						movlw	b'00001000'	;Ax, Bx, CH soit OFF
;						movwf	driveport
						Clrf	driveport
						movlw	227
						 call	 dly8		;temps de OFF variable
						decfsz	tbip,f
						goto	hautd
						clrf	driveport
						clrf	CCPR2L
						
					
						return
					;--------------------------------- bip  Do ---------------------------------
					;---------------------------------------------------------------------------
					;--------------------------------- bip  Mi ---------------------------------
					MI
	Movlw	250
	Movwf	ccpr2L
						movlw	66
						movwf	tbip
					hautm
						movlw	b'00010001'	;Al, Bx, CH soit ON
						movwf	driveport
						movlw	5
						 call	dly8		;temps de ON
					basm
						Clrf	driveport
;						movlw	b'00000001'	;Ax, Bx, CH soit OFF
;						movwf	driveport
						movlw	180
						 call	 dly8		;temps de OFF variable
						decfsz	tbip,f
						goto	hautm
						Clrf	driveport
						clrf	CCPR2L
						return
					;--------------------------------- bip  Mi ---------------------------------
					;---------------------------------------------------------------------------
					;--------------------------------- bip Sol ---------------------------------
					SOL
	Movlw	250
	Movwf	ccpr2L
						movlw	77
						movwf	tbip
					hauts
						movlw	b'00100100'	;Al, Bx, CH soit ON
						movwf	driveport
						movlw	5
						 call	dly8		;temps de ON
					bass
						Clrf	driveport
;						movlw	b'00100000'	;Ax, Bx, CH soit OFF
;						movwf	driveport
						movlw	151
						 call	 dly8		;temps de OFF variable
						decfsz	tbip,f
						goto	hauts
						clrf	driveport
						clrf	CCPR2L
						return
					;--------------------------------- bip Sol ---------------------------------
					

;-------------------------------------------------------------------------------------

					;--------------------------------- bip Sol ---------------------------------

;  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	end
